﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Audio;

namespace Low_Memory_Candy
{
    class Player
    {
        const int maxMem = 1400;

        public Texture2D tex;
        public Vector2 pos;
        public Vector2 vel;
        SpriteEffects direction = SpriteEffects.None;


        public int memory = maxMem;
        public int score = 0;
        public bool gameOver = false;
        public bool trippy = false;
        bool started = false;
        bool stopsec = false;
        bool isJumping = false;
        int step = 4;
        int jumpStep = 15;

        float gameOverTime;
        float trippyTime;

        public SoundEffect[] jumps;
        public SoundEffect[] pickUps;
        public SoundEffect powerup;
        Random ran = new Random();

        public Player()
        {
            // IT'S A AWESOME CONSTRUCTOR
        }

        public void update(GameTime gt)
        {
            KeyboardState state = Keyboard.GetState();
            if (state.IsKeyDown(Keys.Escape)) Environment.Exit(0);

            if (started) memory -= (gt.TotalGameTime.Seconds / 20) + 1;

            if (!gameOver)
            {
                if (state.IsKeyDown(Keys.Left) && pos.X > 0) pos.X -= step;
                else if (state.IsKeyDown(Keys.Right) && pos.X < Game.screenWidth - this.tex.Width) pos.X += step;

                if (state.IsKeyDown(Keys.Up) && !isJumping)
                {
                    vel.Y = -jumpStep;
                    isJumping = true;
                    if (jumps != null)
                    {
                        jumps[ran.Next(jumps.Length)].Play();
                        ran = new Random(ran.Next(int.MaxValue));
                    }
                }
            }
            else
            {
                gameOverTime += gt.ElapsedGameTime.Milliseconds;
                if (gameOverTime > 1250)
                {
                    pos.X -= 4;
                    stopsec = true; // And then just wait for the OutOfRange.
                }
            }

            if (trippy)
            {
                trippyTime += gt.ElapsedGameTime.Milliseconds;
                if (trippyTime > 7500)
                {
                    step = 4;
                    jumpStep = 15;
                    trippy = false;
                }
            }

            if (isJumping)
            {
                pos += vel;
                vel.Y += .5f;
                if ((int)pos.Y == Game.screenHeight - tex.Height)
                {
                    isJumping = false;
                    pos.Y = Game.screenHeight - tex.Height;
                }
            }
        }

        public void hitCandy()
        {
            started = true;
            score += 10;
            memory += 20;
            if (memory > maxMem) memory = maxMem;
            if (pickUps != null)
            {
                pickUps[ran.Next(pickUps.Length)].Play();
                ran = new Random(ran.Next(int.MaxValue));
            }
        }

        public void hitPowerUp()
        {
            trippy = true;
            trippyTime = 0f; // In case you already have one
            step = 14;
            jumpStep = (jumpStep * 2) - 4;
            if (powerup != null) powerup.Play();
        }

        public void draw(SpriteBatch sb, Color clr, SpriteFont font)
        {
            sb.Draw(tex, pos, null, clr, 0f, Vector2.Zero, 1f, direction, 0f);
            if (gameOver && !stopsec) sb.DrawString(font, "What am I even doing here?", new Vector2(pos.X - 102, pos.Y - 22), Color.White);
        }
    }
}
